# Copyright Tony Kaap 2008
# ballStickAnim.py
# This can be used for any legal purpose, as long as this attribution stays
# intact.

# example usages in the Maya Python Script Editor

#import ballStickAnim
#reload(ballStickAnim)
#ballStickAnim.ballStickAnim()

#import ballStickAnim
#reload(ballStickAnim)
#ballStickAnim.ballStickAnim("pSolidShape1")


import maya.cmds as m
import re
from math import *

point_distance = lambda a,b: ((a[0]-b[0])*(a[0]-b[0])+(a[1]-b[1])*(a[1]-b[1]))

def vector(v1,v2):
	return [v2[0]-v1[0],v2[1]-v1[1],v2[2]-v1[2]]
	
def magnitude(v):
	m2 = 0
	for i in xrange(len(v)):
		  m2 += (v[i]*v[i])
	return sqrt(m2)

def midpoint(pt0,pt1):
	return( [(pt0[0]+pt1[0])/2.0, (pt0[1]+pt1[1])/2.0, (pt0[2]+pt1[2])/2.0] )
	
def ballStickAnimSelected(r=0.05,secX=10,secY=5):
	if not obj:
		obj = m.ls(sl=1)[0]
	ballStickAnim(obj,r,secX,secY)
	
import ballStick	
def ballStickAnim(obj=None,r=0.05,secX=10,secY=5,bsGrp=None,timerange=[]):
	if not obj:
		obj = m.ls(sl=1)[0]

	# set how many frames to animate through
	min = 1
	max = 1
	useTimerange = False
	if timerange:
		if len(timerange) == 2:
			min = int(timerange[0])
			max = int(timerange[1])
		else:	
			useTimerange = True
	else:
		useTimerange = True
		
	if useTimerange:
		# use time line range
		min = int(m.playbackOptions(min=True,q=True))
		max = int(m.playbackOptions(max=True,q=True))
	
	print "min " + str(min) + " max " + str(max)

	if not bsGrp:
		#bsGrp = ballStick.ballStick(obj=my_obj, r=my_r, secX=my_secX, secY=my_secY)
		bsGrp = ballStick.ballStick(obj, r, secX, secY)
	
	print "using: " + obj
	v = m.polyEvaluate(obj,v=1)

	
	# gather the lists of spheres and cylinders created to 
	# map the object input.
	[sphGrp, cylGrp] = m.listRelatives(bsGrp, c=1,f=1)
	sphList = m.listRelatives(sphGrp,c=1,f=1)
	cylList = m.listRelatives(cylGrp,c=1,f=1)
		
	for f in range(min,max+1,1):
		m.currentTime(f)
		print "frame " + str(f)

		pts=[]
		for i in xrange(v):
			pts.append(m.xform(obj+".vtx["+str(i)+"]", query=1, translation=1, ws=1))

		#add spheres
		# create a list of existing spheres and sticks in the passed-in group, 
		# and set transform keys on them rather than creating them.
		#
		# You will need to capture the animated range of the target object,
		# you will need to gather an ordered list of the children (just transforms)
		# of the ball group and stick group
		#
		# If the groups don't exist, then run the creation script once to create the 
		# geometry, then this anim script to move it. 
		#
		for i in xrange(v):
			pos = pts[i]
			#(sph,sphNode) = m.polySphere(radius=r, sx=secX,sy=secY)
			#m.connectAttr(grp+".radius",sphNode+".radius")
			#m.connectAttr(grp+".secX",sphNode+".subdivisionsAxis")
			#m.connectAttr(grp+".secY",sphNode+".subdivisionsHeight")
	
			#m.parent(sph,grp)
			sph = sphList[i]
			m.xform(sph, ws=1, translation=pos)
			m.setKeyframe(sph,at="translate")
		
		# add cylinders
		e = m.polyEvaluate(obj,e=1)
		space = re.compile(' +')
		for i in xrange(e):
			v2 = m.polyInfo(obj+".e["+str(i)+"]", edgeToVertex=1)
			v2 = v2[0]
			v2 = space.sub(',',v2) # replace gaps of whitespace with a single comma
			v2 = v2.split(',')
			p0 = int(v2[2])
			p1 = int(v2[3])
			pt0 = pts[p0]
			pt1 = pts[p1]
			mpt = midpoint(pt0,pt1)
			mag = magnitude(vector(pt0,pt1))
			#(cyl,cylNode) = m.polyCylinder(height=mag,sy=0,sx=secX,radius=r_2,ax=(0,0,1))
			#m.connectAttr(cGrp+".radius",cylNode+".radius")
			#m.connectAttr(cGrp+".sec",cylNode+".subdivisionsAxis")
			#h_2 = mag/2.0
			cyl = cylList[i]
			m.setAttr(cyl+".scaleZ", mag)
			
			m.xform(cyl, ws=1,translation=mpt)
			#m.parent(cyl,cGrp)
			# determine the orientation of a z-axis cylinder given two world-space 
			# input points
			rot = orient(pt0,pt1)
			m.rotate(rot[0], rot[1], rot[2] , cyl ,a=1)
			
			m.setKeyframe(cyl,at="translate")
			m.setKeyframe(cyl,at="rotate")
			m.setKeyframe(cyl,at="scale")
			
	return (bsGrp)
		
		
def normalize(v):
	ret = v
	mag = magnitude(v)
	for i in range(len(ret)):
		ret[i] = ret[i]/mag
	return ret

def orient(pt0,pt1):
	radToDeg = 180/pi
	d = normalize(vector(pt0,pt1))
	[dx,dy,dz] = d	
	rx=ry=rz=0
	
	# phi - the angle of elevation
	phi = radToDeg*asin(dy)
	if(dz>0):
		phi*=-1
	
	#theta 	- the angle around the y axis
	if dz==0:
		if dx > 0:
			theta = -90
		else:
			theta = 90
	else:
		theta = radToDeg*atan(dx/dz)
	
	return (phi,theta,0)
