def testStack():
	l = []
	l.append('A')
	l.append('B')
	l.append('C')
	l.append('D')
	print (l.pop())
	print (l.pop())
	print (l.pop())
	print (l.pop())
	
	
# Koch #2
#l.setCustomLanguage( {'F':'FF-F-F-F-F-F+F' } )
#l.setCustomLangInit('F-F-F-F')
#l.setCustomLangAngle(90)
	
# Plant B
#l.setCustomLanguage( {'F':'FF-[-F+F+F]+[+F-F-F]' } )
#l.setCustomLangInit('F')
#l.setCustomLangAngle(23)
	
# Plant C
#l.setCustomLanguage( {'F':'F[+F]F[-F]F' } )
#l.setCustomLangInit('F')
#l.setCustomLangAngle(23.5)


#import maya
#import lSystem
#reload( lSystem)
#l = lSystem.lSystem()
#l = setMaxPoints(50000)
#l.setAngle(90)
#
#l.setCustomLanguage( {'F':'FF-F-F-F-F-F+F' } )
#l.setCustomLangInit('F-F-F-F')
#l.setCustomLangAngle(90)
#l.setLangIndex(-1)
#l.getSentence()
#
#steps = 2
#for i in range(steps):
#	l.step(True)
#l.buildMultiCurve()
#
	
#
#import maya
#import lSystem
#reload( lSystem)
#l = lSystem.lSystem()
#l.setLangIndex(7)
#l.setAngle(90)
#steps = 5
#for i in range(steps):
#	l.step(True)
#l.buildMultiCurve()
#
#
# TODO: 
# 	Possibly add an offset to move the curve according to the number of steps it is recursed
# 	Add a tool to line up or connect multiple curves so that no one curve needs to be super long.


import maya.cmds
import math
class lSystem:
	x = 0  # initial drawing point
	y = 0
			# initial drawing direction
	dir = 0 # {0,1,2,3} => {north, east, south, west} (clockwise, with x = East y = North)
	angle = 0
	
			# The initial 'word' of a lSystem curve
	sentence = 'L';
	initSentence = 'L';
	points = []
	knots = 0
	scale = 1.0
	steps = 0
	maxPoints = 100000
	pointStack = []
	angleStack = []
	customLanguage = {}
	customLangAngle = -1
	customLangInit = ''
		
	# X,Y, L & R are variables that don't include a forward move
	# A & B are variables that DO include a forward move
	# F is just a forward move
	# - & + turn the drawing turtle right and left, respectively
	#
	langIndex = 0
	lang = ['hilbert', 'koch', 'dragon', 'sierpinksi arrowhead','koch snowflake', 'peano gosper', 'peano', 'plant' ]
	hilbertLanguage = {'R':'-LF+RFR+FL-', 'L':'+RF-LFL-FR+'}
	hilbertInit = 'L'
	hilbertAngle = 90
	kochLanguage = {'F':'F+F-F-F+F'}
	kochInit = 'F'
	kochAngle = 90
	dragonLanguage = {'X':'X+YF+', 'Y':'-FX-Y'}
	dragonInit = 'FX'
	dragonAngle = 90
	sierpinskiLanguage = {'A':'B-A-B','B':'A+B+A'}
	sierpinskiInit = 'A'
	sierpinskiAngle = 60
	kSnowflakeLanguage = {'F':'F-F++F-F'}
	kSnowflakeInit = 'F++F++F'
	kSnowflakeAngle = 60
	peanoGosperLanguage = {'X':'X+YF++YF-FX--FXFX-YF+', 'Y':'-FX+YFYF++YF+FX--FX-Y'}
	peanoGosperInit = 'X'
	peanoGosperAngle = 60	
	peanoLanguage = {'F':'F+F-F-F-F+F+F+F-F'}
	peanoInit = 'F'
	peanoAngle = 90
	plantLanguage = { 'X':'F-[[X]+X]+F[+FX]-X', 'F':'FF' }
	plantInit = 'X'
	plantAngle = 25
	languages = [hilbertLanguage, kochLanguage, dragonLanguage, sierpinskiLanguage, kSnowflakeLanguage, peanoGosperLanguage, peanoLanguage, plantLanguage]
	initWords = [hilbertInit, kochInit, dragonInit, sierpinskiInit, kSnowflakeInit, peanoGosperInit, peanoInit, plantInit]
	langAngles = [hilbertAngle, kochAngle, dragonAngle, sierpinskiAngle, kSnowflakeAngle, peanoGosperAngle, peanoAngle, plantAngle]
	
	def __init__(self):
		self.reset()
		
	def reset(self):
		self.x = 0
		self.y = 0
		self.dir = 0
		self.angle = 0
		self.langIndex = 0
		self.initSentence = self.initWords[self.langIndex]
		self.sentence = self.initSentence
		points = []
		knots=0
		self.built = False
		self.steps = 0
		self.scale = 1.0

	def setCustomLanguage(self, language):
		self.customLanguage = language
	def getCustomLanguage(self):
		print self.customLanguage
	def setCustomLangInit(self,init):
		self.customLangInit = init
	def getCustomLangInit(self):
		return self.customLangInit
	def setCustomLangAngle(self, angle):
		self.customLangAngle = angle
	def getCustomLangAngle(self):
		return self.customLangAngle

	def setLangIndex(self, index):
		if index < 0: # for custom input languages
			self.langIndex = -1
			self.sentence = self.customLangInit
			self.initSentence = self.customLangInit
		elif index < len(self.languages):
			self.langIndex = index
			self.initSentence = self.initWords[self.langIndex]
			print "New lanuage: " + self.lang[self.langIndex]
		else:
			print "error - langIndex: " + str(self.langIndex) + " is too high (max: " + str(len(self.languages)-1) + ")" 
		self.sentence = self.initSentence
		
		#print "index " + str(self.langIndex)
		#print "index " + str(index)
		#print "sentence: " + self.sentence
		#print "sentence: " + self.initSentence
		#print self.initWords[0]
		#print self.initWords[1]
		
	def getLangIndex(self):
		return self.langIndex
		
	def getLanguage(self):
		return lang[self.langIndex]

	def setMaxPoints(self, max):
		self.maxPoints = max
	def getMaxPoints(self):
		return self.maxPoints

	def step(self, keepScale = False):
		new = ''
		if self.langIndex == -1:
			ld = self.customLanguage
			for word in self.sentence:	
				if(ld.has_key(word)):
					new += ld[word]
				else:
					new += word
		elif self.langIndex < len(self.languages):
			ld = self.languages[self.langIndex]
			for word in self.sentence:	
				if(ld.has_key(word)):
					new += ld[word]
				else:
					new += word
		else:
			print "error - langIndex: " + str(self.langIndex) + " is too high (max: " + str(len(self.languages)) + ")" 
		self.sentence = new
		if not keepScale:
			self.setScale(self.scale / 2)
		self.steps += 1
		self.built = False

	#use the scale and angle to produce and offset to the current point
	def move(self, x,y, angle):
		dX = math.cos(math.radians(angle))
		dY = math.sin(math.radians(angle))
		#print "dx: " + str(dX)+" dy: " + str(dY)
		x += self.scale*dX
		y += self.scale*dY
		return [x,y]
		
	def delta(self, angle):
		dX = math.cos(math.radians(angle))
		dY = math.sin(math.radians(angle))
		return [dX,dY]
	
	def buildMultiCurve(self):
		print self.getSentence()
		#del self.points # to clear the list
		pointStack = []
		angleStack = [];
		points = []
		knots = 0
		
		x = self.x
		y = self.y
		z = 1
		points.append( (x, y, 0) )

		# When you parse a '[', save the point and direction
		# When you parse a ']', create the current curve, pop the point and dir from 
		# the stack, and append that point as the beginning of a new curve. 		

		dir = self.dir
		angle = self.angle
		if(self.langIndex == -1):
			langAngle = self.customLangAngle
		else:
			langAngle = self.langAngles[self.langIndex]
		wordNum = 1
		for word in self.sentence:
			#print "dir: " + str(dir)
			#print "current word:" + word
			if word == 'F' or word == 'A' or word == 'B':
				[dX,dY] = self.delta(angle)
				x += dX
				y += dY
				#print "MOVE_TO ("+str(wordNum)+"): x " + str(x) + " y " + str(y) + ' z: ' + str(z)
				points.append( (x,y,0) )
			elif word == '+': # turn left
				angle = (angle + langAngle) % 360;
				#print 'left' + str(dir)
			elif word == '-': # turn right
				angle -= langAngle
				if angle < 0:
					angle += 360
				#print 'right' + str(dir)
			elif word == '[': # save point and angle to the stack
				#print "PUSH ("+str(wordNum)+"): x " + str(x) + " y " + str(y) + ' z: ' + str(z)
				pointStack.append((x,y, 0))
				angleStack.append(angle)
			elif word == ']': 
				# create the current curve, clear the points and knots,
				# clear the points and knots
				# pop a point and angle from the stack
				# append that point and knot onto the lists for the current curve
				if(len(points) > 1):
					#print "drawing " + str(len(points)) + " points."
					#print points
					self.createMayaCurve(points, len(points))
				points = []
				(x,y,z) = pointStack.pop()
				angle = angleStack.pop()
				#print "POP("+str(wordNum)+"): x " + str(x) + " y " + str(y) + ' z: ' + str(z)
				points.append((x,y,0))
			wordNum += 1
			
		#	Make sure to create the current curve
		if(len(points) > 1):
			self.createMayaCurve(points, len(points))
		#print "pts: = " + str(len(self.points)) 
		#self.built = True

	def createMayaCurve(self, points, knotLength):
		numPts = len(points)
		#print "cMC: num points: " + str(numPts)
		if numPts < self.maxPoints:
			#print points
			maya.cmds.curve(degree=1, p=points, k = range(knotLength) )
		else:
			print "ERROR: Maya can't handle creating curves of more than "+ str(self.maxPoints) + " points.  You are requesting " + str(numPts) + " points."	

	def setXY(self, x=0, y=0):
		self.x = x
		self.y = y
	
	def getX(self):
		return self.x
	def getY(self):
		return self.y
	
	def setDir(self, direction):
		self.dir = direction
	def getDir(self):
		return self.dir
	
	def getAngle(self):
		return self.angle
	def setAngle(self, angle):
		self.angle = angle
	
	def getScale(self):
		return self.scale
	
	def setScale(self, scale):
		self.scale = scale

#	def flipCurve(self):
#		if(self.initSentence == 'L'):
#			self.initSentence = 'R'
#		elif(self.initSentence == 'R'):
#			self.initSentence = 'L'

	def getSentence(self):
		return self.sentence
	
	# only show +,-,and F
	# as long as you use L and R for vowels...
	def getDrawSteps(self):
		steps = self.sentence
		steps = steps.replace('L','')
		steps = steps.replace('R','')
		steps = steps.replace('B','')
		steps = steps.replace('A','')
		return steps
	
	# this should rarely, if ever, be used
	def setSentence(self, sentence):
		self.sentence = sentence
		
 	def createCurve(self):
		if not self.built:
			self.buildCurve()
		#print self.points
		#print range(self.knots)
		numPts = len(self.points)
		if numPts < self.maxPoints:
			maya.cmds.curve(degree=1, p=self.points, k = range(self.knots) )
		else:
			print "ERROR: Maya can't handle creating curves of more than "+ str(self.maxPoints) + " points.  You are requesting " + str(numPts) + " points."	

	
	def getSteps(self):
		return self.steps
	def getNumPoints(self):
		if(self.built):
			return len(self.points)
		else:
			print "Curve not built, yet."
			return -1

	def addPoint(self, x,y):
	#	print "adding point:"
		self.points.append( (x, y, 0) )
		self.knots += 1

